package gov.va.med.mhv.vitals.converter;

import gov.va.med.mhv.vitals.dto.BodyTemperatureDTO;
import gov.va.med.mhv.vitals.model.BodyTemperatureReading;

import java.util.ArrayList;
import java.util.List;

public class BodyTemperatureConverter {
	
	public static BodyTemperatureDTO  convertBodytempReadingDomain( BodyTemperatureReading tempReading ){
		BodyTemperatureDTO dto = new BodyTemperatureDTO();
		dto.setBodyTemperature(tempReading.getBodyTemperature());
		dto.setBodyTemperatureId(tempReading.getId());
		dto.setBodyTemperatureMethod(tempReading.getBodyTemperatureMethod());
		dto.setComments(tempReading.getComments());
		dto.setReading(tempReading.getReading());
		dto.setMeasure(tempReading.getMeasure());
		dto.setUserprofileId(tempReading.getUserprofileId());
		return dto;
		
	}
	
	public static BodyTemperatureReading convertBodytempReadingDTO(BodyTemperatureDTO tempReadingDTO){
		BodyTemperatureReading bodyTempReading = new BodyTemperatureReading();
		bodyTempReading.setBodyTemperature(tempReadingDTO.getBodyTemperature());
		bodyTempReading.setBodyTemperatureMethod(tempReadingDTO.getBodyTemperatureMethod());
		bodyTempReading.setComments(tempReadingDTO.getComments());
		bodyTempReading.setId(tempReadingDTO.getBodyTemperatureId());
		bodyTempReading.setMeasure(tempReadingDTO.getMeasure());
		bodyTempReading.setOplock(0);
		bodyTempReading.setReading(tempReadingDTO.getReading());
		bodyTempReading.setUserprofileId(tempReadingDTO.getUserprofileId());
		return bodyTempReading;
		
	}
	
	public static List<BodyTemperatureDTO>  convertBodytempReadings( List<BodyTemperatureReading> tempReadings ){
		
		List<BodyTemperatureDTO> tempReadingDTOS = new ArrayList<BodyTemperatureDTO>();
		for(BodyTemperatureReading tempReading : tempReadings){
			BodyTemperatureDTO dto = convertBodytempReadingDomain(tempReading);
			tempReadingDTOS.add(dto);
		}
		return tempReadingDTOS;
	}

}
